ArrayList<Shape> objs = new ArrayList<Shape>();
color color1 = color(255, 0, 0);
color color2 = color(0, 255, 0);
color color3 = color(0, 0, 255);
color currentColor = color1;

int TRIANGLE = 0;
int RECT = 1;
int currentShape = TRIANGLE;
Shape selectedShape = null;

void setup(){  
  size(1400, 1200);
}

void draw(){
  background(196);
  fill(255);
  strokeWeight(1);
  stroke(0);
  rect(32+2*8, 0, width-2*32-4*8, height);
  
  // on dessine (au fond=derriere) tous les objets
  for (Shape obj: objs){
    obj.draw();
  }
  
  // on dessine par dessus la forme encours ou selectionnee
  strokeWeight(4);
  if(selectedShape != null)
    selectedShape.draw();
  // ondessine chaque bouton 1 par 1 en changeant l'epaisseur selon le mode de dessin
  
  if (currentColor == color1) strokeWeight(4); else strokeWeight(1);
  stroke(0);
  fill(color1);
  rect (8, 8, 32, 32);

  if (currentColor == color2) strokeWeight(4); else strokeWeight(1);
  fill(color2);
  rect (8, 8*2+32*1, 32, 32);
  
  if (currentColor == color3) strokeWeight(4); else strokeWeight(1);
  fill(color3);
  rect (8, 8*3+32*2, 32, 32);
  
  if (currentShape == TRIANGLE) strokeWeight(4); else strokeWeight(1);
  fill(196);
  rect (width-8-32, 8, 32, 32);
  strokeWeight(2);
  fill(255);
  triangle(width-8-32+5, 8+5,
           width-8-32+26, 8+12,
           width-8-32+12, 8+27);
           
  if (currentShape == RECT) strokeWeight(4); else strokeWeight(1);
  fill(196);
  rect (width-8-32, 8*2+32*1, 32, 32);
  strokeWeight(2);
  fill(255);
  rect(width-8-32+5, 8*2+32*1+7, 22, 16);
}


void mouseClicked(){
  // chaque bouton a sa zone qui peut etre testee zone de dessin
  // pour savoir dans quel bouton l'utilisateurice a cliquee
  
  if(mouseX>8 && mouseX<8+32 && mouseY>8*1+0*32 && mouseY<8*1+1*32)
    currentColor = color1;

  else if(mouseX>8 && mouseX<8+32 && mouseY>8*2+1*32 && mouseY<8*2+2*32)
    currentColor = color2;
    
  else if(mouseX>8 && mouseX<8+32 && mouseY>8*3+2*32 && mouseY<8*3+3*32)
    currentColor = color3;
    
  else if(mouseX>width-8-32 && mouseX<width-8 && mouseY>8*1+0*32 && mouseY<8*1+1*32)
    currentShape = TRIANGLE;

  else if(mouseX>width-8-32 && mouseX<width-8 && mouseY>8*2+1*32 && mouseY<8*2+2*32)
    currentShape = RECT;
}
 
    
void mousePressed(){
  // on est dans la zone de dessin
  if(mouseX>8+32 && mouseX<width-8-32) {

    // si on commence un dessin de rectangle
    if(currentShape == RECT && selectedShape==null){
      Rectangle r  = new Rectangle(); //on cree l'objet 
      r.col = currentColor; // on met a jour sa couleur
      r.p1 = new PVector(mouseX, mouseY);// on met a jour son premier point
      r.dims = new PVector(0, 0); // on met des dimensions nulles par defaut
      selectedShape = r; // on dit que ce nouvel objet est le nouvel objet selectionne
    
    // si on commence un nouveau triangle
    } else if(currentShape == TRIANGLE && selectedShape==null){
      Triangle t  = new Triangle();
      t.col = currentColor;
      t.p1 = new PVector(mouseX, mouseY);
      t.ptToDraw = 2; // on met a jour son compte a rebour de points
      selectedShape = t;
    
    // si on a deja un triangle en cours de creation 
    } else if(currentShape == TRIANGLE && selectedShape!=null){
      Triangle t = (Triangle)selectedShape;
      if(t.ptToDraw==2){ // selon ou on en est du noombre de points qui restent a donner
        t.p2 = new PVector(mouseX, mouseY);
        t.ptToDraw = 1;
      } else if(t.ptToDraw==1){
        t.p3 = new PVector(mouseX, mouseY);
        t.ptToDraw = 0;
      }
    }
  }
}

void mouseDragged(){
  // uniquement pour les rectangles on met a jour les dimensions
  if(currentShape == RECT && selectedShape!=null){
    Rectangle r = (Rectangle)selectedShape;
    r.dims = new PVector(mouseX-r.p1.x,mouseY-r.p1.y);
  }
}

void mouseReleased(){
  // dans mouseReleased (et selon ou on en est de la creation)
  // on fait passer la selectedShape dans la liste des objets "classiques" 
  if(currentShape == RECT && selectedShape!=null){
    objs.add(selectedShape);
    selectedShape = null;
  }
  if(currentShape == TRIANGLE && selectedShape!=null && ((Triangle)selectedShape).ptToDraw==0){
    objs.add(selectedShape);
    selectedShape = null;
  }
}
